using System.Data;

namespace gov.va.med.vbecs.DAL.VAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stanislav Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>12/22/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Provides means for getting workload codes information from VistA via VistALink.</summary>

	#endregion

	public class WorkloadCodes
	{
		private const string WORKLOAD_CODES_LOOKUP_RPC_NAME = "VBECS WORKLOAD CODES LOOKUP";

		private WorkloadCodes() {}

		///<Developers>
		///	<Developer>Brian    lin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/18/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4443"> 
		///		<ExpectedInput>VistALink is connected</ExpectedInput>
		///		<ExpectedOutput>
		///			Non-Empty DataSet with expected data containing
		///			a list of workload codes and related data from VistA.
		///		</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4444"> 
		///		<ExpectedInput>VistALink is not connected.</ExpectedInput>
		///		<ExpectedOutput>InvalidOperationException.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetWorkloadCodeData
		/// </summary>
		/// <returns>DataSet</returns>
		public static DataSet GetWorkloadCodeData()
		{
			// Try cache table first
			DataSet dsWorkloadCodes = VistaCache.GetWorkloadAndCptCache();
			//
			if (dsWorkloadCodes != null && dsWorkloadCodes.Tables.Count > 0 && dsWorkloadCodes.Tables[0].Rows.Count > 0)
			{
				return dsWorkloadCodes;
			}
			else
			{
				string rpcResults = VistALink.GetRpcBroker().ExecuteRpc( VistALink.CreateRpcRequest(WORKLOAD_CODES_LOOKUP_RPC_NAME) );
				//
				return DataTransformUtility.LoadXmlStringIntoDataSet( rpcResults );
			}
		}
	}
}
